WITH
T_VOL AS
(
SELECT o.object_id,
       SUM(p.rows) AS ROW_COUNT,
       CAST((SUM(au.total_pages) * 8) / 1024.0 AS DECIMAL(18,3)) AS TOTAL_SPACE_MB,
       CAST(SUM(au.used_pages) * 8 / 1024.0 AS DECIMAL(18,3)) AS USED_SPACE_MB,
       CAST((SUM(au.total_pages) - SUM(au.used_pages)) * 8 / 1024.0 AS DECIMAL(18,3)) AS UNUSED_SPACE_MB
FROM   sys.objects AS o
       INNER JOIN sys.indexes i
             ON o.object_id = i.object_id
       LEFT OUTER JOIN sys.partitions AS p
             ON i.object_id = p.OBJECT_ID AND i.index_id = p.index_id
       LEFT OUTER JOIN sys.allocation_units AS au
             ON p.partition_id = au.container_id
GROUP BY o.object_id
)
SELECT s.name AS TABLE_SCHEMA,
       o.name AS TABLE_NAME,
       o.type_desc AS TABLE_TYPE,
       i.name AS INDEX_NAME,
       ROW_COUNT,
       TOTAL_SPACE_MB,
       USED_SPACE_MB,
       UNUSED_SPACE_MB,
       fg.name AS FILE_GROUP,
       df.name AS LOGICAL_FILE,
       df.physical_name AS PHYSICAL_FILE,
       o.object_id,
       i.index_id,
       p.partition_id
FROM   sys.objects AS o
       INNER JOIN sys.schemas AS s
             ON o.schema_id = s.schema_id
       INNER JOIN sys.indexes i
             ON o.object_id = i.object_id
       LEFT OUTER JOIN sys.filegroups AS fg
             ON i.data_space_id = fg.data_space_id
       LEFT OUTER JOIN sys.database_files AS df
             ON fg.data_space_id = df.data_space_id
       LEFT OUTER JOIN sys.partitions AS p
             ON i.object_id = p.OBJECT_ID AND i.index_id = p.index_id
       LEFT OUTER JOIN T_VOL AS V
             ON o.object_id = V.object_id
WHERE  o.is_ms_shipped = 0
  AND  i.OBJECT_ID > 255;